import * as fs from 'fs';

interface IParameter {
    main: string;
    name: string;
    out: string;
}
const parameter: Partial<IParameter> = {};
process.argv.forEach((val: string) => {
    if (val.substr(0, 2) === '--') {
        const part = val.substr(2).split('=');
        (parameter as any)[part[0].trim()] = part[1].trim();
    }
});
const pathReg = /((.*)\/)?(.*?).js$/;

if (!parameter.main || !parameter.main.match(pathReg)) {
    console.error(`Syntax error: wrap --main=main.js [--name=function_name] [--out=./build]`);
    process.exit(-1);
}


if (!parameter.name) {
    parameter.name = parameter.main!.match(pathReg)![3];
}

if (!parameter.out) {
    const part = parameter.main!.match(pathReg);
    parameter.out = `${part![1]}${parameter.name === part![3] ? `${parameter.name.toLocaleLowerCase()}-wrapworker.js` : parameter.name.toLocaleLowerCase()}.js`;
}

fs.readFile(parameter.main!, 'utf8', (err: Error, data: string) => {
    if (!!err) {
        throw err;
    }

    const template = `function ${parameter.name}() {
${data}
};

if (typeof window === 'undefined' || window != self) {
    ${parameter.name}();
} else {
    window.${parameter.name} = ${parameter.name};
}
`;
    fs.writeFile(parameter.out!, template, (err: Error) => {
        if (!!err) {
            throw err;
        }

        console.log(`Write to: ${parameter.out} (length: ${template.length}).`);
    });
});
