"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs = __importStar(require("fs"));
const parameter = {};
process.argv.forEach((val) => {
    if (val.substr(0, 2) === '--') {
        const part = val.substr(2).split('=');
        parameter[part[0].trim()] = part[1].trim();
    }
});
const pathReg = /((.*)\/)?(.*?).js$/;
if (!parameter.main || !parameter.main.match(pathReg)) {
    console.error(`Syntax error: umd --main=main.js [--name=module] [--out=./build]`);
    process.exit(-1);
}
if (!parameter.name) {
    parameter.name = parameter.main.match(pathReg)[3];
}
if (!parameter.out) {
    const part = parameter.main.match(pathReg);
    parameter.out = `${part[1]}${parameter.name === part[3] ? `${parameter.name.toLocaleLowerCase()}-umd` : parameter.name.toLocaleLowerCase()}.js`;
}
fs.readFile(parameter.main, 'utf8', (err, data) => {
    if (!!err) {
        throw err;
    }
    const template = `(function(root, factory) {
    if (typeof define === 'function' && define.amd)
      define([/* dependencies */], factory);
    else if (typeof exports === 'object' && !!exports && !exports.nodeType) {
      if (typeof module === 'object' && !!module && module.exports)
        module.exports = factory(/* dependencies */);
      else
        exports['default'] = factory(/* dependencies */);
    } else if (typeof YUI === 'function' && YUI.add)
      YUI.add('${parameter.name}', function (Y) { Y['default'] = factory(); });
    else
      root['${parameter.name}'] = factory();
}((function () {
    try {
      return Function('return this')() || (42, eval)('this');
    } catch (e) {
      return self;
    }
})(), function(/* dependencies */) {
var ${parameter.name};
${data}
return ${parameter.name};
}));
`;
    fs.writeFile(parameter.out, template, (err) => {
        if (!!err) {
            throw err;
        }
        console.log(`Write to: ${parameter.out} (length: ${template.length}).`);
    });
});
