"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = require("fs");
if (process.argv.length < 3) {
    console.log('Usage: node catscss.js <dir>|<file>');
    process.exit(-1);
}
const fileOrDirectory = process.argv.slice(2);
function isScss(file) {
    return file.stats.isDirectory() || file.path.split('.').pop() === 'scss';
}
function processDirectory(path) {
    const fileList = fs_1.readdirSync(path);
    fileList.map(file => {
        return {
            path: path + '/' + file,
            stats: fs_1.lstatSync(path + '/' + file)
        };
    }).filter(isScss).sort((a, b) => {
        if (a.stats.isDirectory() === b.stats.isDirectory()) {
            return a.path.toLowerCase().localeCompare(b.path.toLowerCase());
        }
        return a.stats.isDirectory() ? 1 : -1;
    }).map(file => file.path).forEach(processCat);
}
function processFile(path) {
    console.log(fs_1.readFileSync(path, {
        encoding: 'utf-8'
    }));
}
function processCat(path) {
    const stats = fs_1.lstatSync(path);
    if (stats.isDirectory()) {
        processDirectory(path);
    }
    else if (isScss({ path, stats })) {
        processFile(path);
    }
    else {
        console.warn(`Unknown: ${path}`);
    }
}
fileOrDirectory.forEach(processCat);
