import { Database } from './db';
import { cache } from '../../shared/@decorators/function';
import { IDeal } from '../../shared/models/deals';

/**
 * Deals database service
 */
class Deals extends Database<Array<IDeal>, string | RegExp> {
    public constructor() {
        super();
    }

    protected initialize() { /* */ }

    /**
     * Get all deals for a given city
     * @param cityName Name of the city
     */
    @cache(10)
    public find(cityName: string): Promise<Array<IDeal>> {
        return this.getDB().then((db) => {

            const lowerCityName = cityName.toLowerCase();
            return db.deals.filter(deal => deal.departure.toLowerCase() === lowerCityName);
        });
    }

    /**
     * Return currency of the database
     */
    public getCurrency(): Promise<string> {
        return this.getDB().then(db => db.currency);
    }
}

const DealsDb = new Deals();

export default DealsDb;
