import { Database } from './db';
import { ICity } from '../../shared/models/cities';

/**
 * Cities service to get list of City
 */
class Cities extends Database<Set<ICity>, string | RegExp> {
    private dataIndex: Promise<Set<ICity>> | undefined;

    public constructor() {
        super();
    }

    protected initialize() {
        this.dataIndex = this.getDB().then((db) => {
            const cityNameSet = new Set<string>();
            db.deals.forEach(deal => cityNameSet.add(deal.departure).add(deal.arrival));

            const citiesSet = new Set<ICity>();
            cityNameSet.forEach(cityName => citiesSet.add({ name: cityName }));

            return citiesSet;
        });
    }

    /**
     * Fetch a city
     * @param cityName Full/Partial name of city to retrieve
     */
    public find(cityName: string | RegExp): Promise<Set<ICity>> {
        return this.dataIndex!.then((cities) => {
            const result: Set<ICity> = new Set();
            cities.forEach((city) => {
                if (city.name.match(cityName)) {
                    result.add(city);
                }
            });

            return result;
        });
    }
}

const CitiesDb = new Cities();

export default CitiesDb;
