import { Autocomplete } from './commands/autocomplete';
import { ICommand } from './commands/ICommand';
import ECommand from '../shared/ECommand';
import { Direction } from './commands/direction';

const CommandMap: {
    [key: string]: ICommand<any>;
} = {
    [ECommand.Autocomplete]: new Autocomplete(1),
    [ECommand.Direction]: new Direction()
};

function loadCommand() {
    onmessage = (e: MessageEvent) => {
        const id = e.data.id;
        const command = e.data.command as ECommand;
        const args: Array<string> = e.data.args;
        CommandMap[command].execute(...args).then((response) => {
            // @ts-ignore TS Definition
            postMessage({
                id,
                response
            });
        }).catch((error) => {
            // @ts-ignore TS Definition
            postMessage({
                id,
                error
            });
        });
    };
}

function main() {
    loadCommand();
}

main();
