import * as React from 'react';
import { reactcomponent } from '../../../@decorators/react';
import AutocompleteSingleton from '../../../services/autocomplete';
import { SearchPage } from './search';
import { ButtonBaseRadio } from '../../elements/form/radio/button/button.base.template';
import { AutocompleteSelectBaseForm } from '../../elements/form/select/autocomplete/autocomplete.base.template';
import { ENavigationMode } from '../../elements/form/select/autocomplete/autocomplete';

export class SearchBasePage extends SearchPage {
    @reactcomponent(false, 'page')
    public render() {

        return (
            <div>
                <AutocompleteSelectBaseForm
                    placeholder='From'
                    autocompleteService={AutocompleteSingleton}
                    onSelectItem={item => this.onSelectDeparture(item)}
                    ref={this.inputDepartureRef}
                />
                <AutocompleteSelectBaseForm
                    placeholder='To'
                    autocompleteService={AutocompleteSingleton}
                    exclude={[this.state.departure]}
                    onSelectItem={item => this.onSelectArrival(item)}
                    ref={this.inputArrivalRef}
                />
                <ButtonBaseRadio
                    items={[{ label: 'Cheapest', value: 'cost' }, { label: 'Fastest', value: 'duration' }]}
                    selected={this.state.mode}
                    onSelectItem={(item) => this.onSelectMode(item)}
                />
                <button type='submit' onClick={() => this.onSubmit()}><i {...{ icon: 'search-white' } as any}></i>Search</button>
            </div>
        );
    }
}

export default SearchBasePage;
