import { IAComponentProps, IAComponentState, AComponent } from '../acomponent';

export interface ISearchForm {
    /**
     * City from
     */
    departure: string;
    /**
     * City to
     */
    arrival: string;
    /**
     * Optimize search by
     */
    mode: 'cost'|'duration';
}

export interface ITripSorterProps extends IAComponentProps {}

export interface ITripSorterState extends IAComponentState {
    /**
     * List of search parameters
     */
    searchParameters: ISearchForm | null;
}

/**
 * Main class for Application
 */
export class TripSorter extends AComponent<ITripSorterProps, ITripSorterState> {
    public constructor(props: ITripSorterProps) {
        super(props);
    }

    protected getInitState(state: ITripSorterState) {
        return Object.assign({
            searchParameters: null
        } as ITripSorterState, state);
    }

    /**
     * Trigger search result
     * @param searchParameters List of search parameters
     */
    protected onSearchSubmit(searchParameters: ISearchForm) {
        this.safeSetState({
            searchParameters
        });
    }

    /**
     * Go back to search form
     */
    protected onSearchReset() {
        this.safeSetState({
            searchParameters: null
        });
    }
}

export default TripSorter;
