import * as React from 'react';
import { reactcomponent } from '../../@decorators/react';
import { ResultBasePage } from '../pages/result/result.base.template';
import { SearchBasePage } from '../pages/search/search.base.template';
import { TripSorter } from './tripsorter';

export class TripSorterBase extends TripSorter {
    @reactcomponent(false, 'app')
    public render() {

        return (
            <div>
                <h1>TripSorter</h1>
                {this.state.searchParameters ?
                    <ResultBasePage
                        departure={this.state.searchParameters.departure}
                        arrival={this.state.searchParameters.arrival}
                        mode={this.state.searchParameters.mode}
                        onReset={() => this.onSearchReset()}
                    /> :
                    <SearchBasePage onSubmit={(searchParams) => this.onSearchSubmit(searchParams)} />
                }
            </div>
        );
    }
}

export default TripSorterBase;
