import * as React from 'react';
import { reactcomponent } from '../../../../../@decorators/react';
import { AutocompleteSelectForm } from './autocomplete';
import { FilteredBaseList } from '../../../list/fltered/filtered.base.template';

export class AutocompleteSelectBaseForm extends AutocompleteSelectForm {
    @reactcomponent()
    public render() {
        if (this.state.shouldReloadSuggest) {
            this.prepareReloadSuggest();
        }

        return (
            <div>
                <input
                    type='text'
                    placeholder={this.props.placeholder}
                    value={this.state.value}
                    onChange={(e) => this.onChange(e)}
                    onFocus={() => this.onInputFocus()}
                    onBlur={() => this.onInputBlur()}
                    onKeyDown={(e) => this.onInputKeyDown(e)}
                    required={true}
                    ref={this.searchInputRef}
                />
                <FilteredBaseList
                    items={this.state.isFocus ? this.state.suggest : []}
                    onSelectItem={item => this.onSelectItem(item)}
                    onHighlightItem={index => this.onHightlightItem(index)}
                    selectedIndex={this.state.highlightItemIndex}
                />
                {this.state.error ? <p>{this.state.error}</p> : ''}
            </div>
        );
    }
}

export default AutocompleteSelectBaseForm;
