import * as React from 'react';
import { reactcomponent } from '../../../../../@decorators/react';
import { ButtonRadio } from './button';

export class ButtonBaseRadio extends ButtonRadio {
    @reactcomponent()
    render() {
        return (
            <ul>
                {this.props.items.map((item, index) => {
                    const uniqueId = `${item.value}-${item.label}`;
                    return (
                        <li key={uniqueId}>
                            <input
                                type='radio'
                                id={uniqueId}
                                value={item.value || item.label}
                                checked={(item.value || item.label) === this.props.selected || (!this.props.selected && index === 0)}
                                onChange={() => this.onSelectButton(item)}
                            /><label htmlFor={uniqueId}>{item.label || item.value}</label>
                        </li>
                    );
                })}
            </ul>
        );
    }
}

export default ButtonBaseRadio;
