import * as React from 'react';

export interface IAComponentProps {}
export interface IAComponentState {}

/**
 * Base class of all Component
 */
export abstract class AComponent<P extends IAComponentProps, S extends IAComponentState> extends React.Component<P, S> {
    private _isMounted: boolean;
    public constructor(props: P) {
        super(props);

        this.state = this.getInitState({});
        this._isMounted = false;
    }

    /**
     * SetState only if the component is Mounted.
     */
    protected safeSetState<K extends keyof S>(
        state: ((prevState: Readonly<S>, props: P) => (Pick<S, K> | S | null)) | (Pick<S, K> | S | null),
        callback?: () => void
    ): void {
        if (this._isMounted) {
            this.setState(state, callback);
        }
    }

    public componentDidMount() {
        this._isMounted = true;
    }

    public componentWillUnmount() {
        this._isMounted = false;
    }

    /**
     * Replace getInitialState.
     * @param state Initial State
     */
    protected abstract getInitState(state: Partial<S>): S;
}

export default AComponent;
