# TripSorter for PropertyFinder.ae

Assignment for PropertyFinder.ae

## Command execution

After fetching the project, install all dependencies with:

```npm install```

Then:

- To start the application:

```npm start```

- To develop the application:

```npm run watch```

- To build for development purpose:

```npm run build```

- To export in final stage:

```npm run export```

## Description
The full application shoud work from the user's point of view.

From the technical's point of view, some improvements can be made.
As this assignment was done in my free-time, for personal reason, I wasn't able to work as much as expected.
Finally, I ran out of time and I'm aware that the assignment may be lacking in that area.

## Improvement
- Flux architecture: the current implementation of React is the most basic one: each component interact with some callback pass through `props`. This part can be improved by using some Flux implementation like `react-redux`, combined with `redux-thunk` to delay some actions (async request).
- Routing: this single-page-app doesn't manage routing. So it manages its content with a simple boolean (as there are only 2 "pages"). `react-router` with `connected-react-router` may be considered.
- More Unit test. The architecture of the unit test is implemented, but this project needs to have strong unit test written for each feature: `mocha`/`chai` for features, and `jest`/`Enzyme` for React component. Or wrap all of them directly with `KarmaJS`. And for Code Coverage, see to use `Istanbul`.
- Task manager: all process were written in a very low level to show that we can do all basic thing without any limitation. Naturally, this part can be refactored by using `webpack`.

## Note
This project is designed to be used in a Data-Driven Framework. The `ComponentResolver` should be used after breaking the dependency between `component` by using `Flux Architecture` or `Self-Sufficient Components Architecture`.
Naturally, the `ComponentResolver` should be connected to the `Data Profile Center Service`.
Here, all components are tagged with `base` as a default value.